/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.data.service.impl;

import cn.hutool.core.collection.ListUtil;
import com.elitesland.cbpl.bpmn.config.BpmnProperties;
import com.elitesland.cbpl.bpmn.data.convert.TaskInstanceConvert;
import com.elitesland.cbpl.bpmn.data.entity.TaskInstanceDO;
import com.elitesland.cbpl.bpmn.data.repo.TaskInstanceRepo;
import com.elitesland.cbpl.bpmn.data.repo.TaskInstanceRepoProc;
import com.elitesland.cbpl.bpmn.data.service.TaskInstanceService;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstanceDeleteParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstancePagingParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstanceSaveParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskInstanceDetailVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskInstancePagingVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.cron.CronPatternUtils;
import com.elitesland.cbpl.tool.db.PagingVO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskInstanceServiceImpl
implements TaskInstanceService {
    private static final Logger logger = LoggerFactory.getLogger(TaskInstanceServiceImpl.class);
    private final TaskInstanceRepo taskInstanceRepo;
    private final TaskInstanceRepoProc taskInstanceRepoProc;

    @Override
    public PagingVO<TaskInstancePagingVO> taskInstancePageBy(TaskInstancePagingParamVO query) {
        long count = this.taskInstanceRepoProc.taskInstanceCountBy(query);
        if (count > 0L) {
            List<TaskInstancePagingVO> list = this.taskInstanceRepoProc.taskInstancePageBy(query);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public TaskInstanceDetailVO taskInstanceById(Long id) {
        Optional taskInstanceDO = this.taskInstanceRepo.findById(id);
        if (taskInstanceDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        return TaskInstanceConvert.INSTANCE.doToVO((TaskInstanceDO)taskInstanceDO.get());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Long save(TaskInstanceSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            TaskInstanceDO taskInstanceDO = TaskInstanceConvert.INSTANCE.saveParamToDO(saveParam);
            this.taskInstanceRepo.save(taskInstanceDO);
            return taskInstanceDO.getId();
        }
        Optional taskInstanceDO = this.taskInstanceRepo.findById(saveParam.getId());
        if (taskInstanceDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        TaskInstanceDO taskInstance = (TaskInstanceDO)taskInstanceDO.get();
        TaskInstanceConvert.INSTANCE.saveParamMergeToDO(saveParam, taskInstance);
        this.taskInstanceRepo.save(taskInstance);
        return taskInstance.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void update(TaskInstanceSaveParamVO saveParam) {
        this.taskInstanceRepoProc.update(saveParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> deleteInstance(TaskInstanceDeleteParamVO paramVO, String source) {
        if (!paramVO.isEmpty()) {
            logger.debug("[BPMN] {} delete instance: {}", (Object)source, (Object)BeanUtils.toJsonStr((Object)paramVO));
            return this.taskInstanceRepoProc.delete(paramVO);
        }
        return ListUtil.empty();
    }

    @Override
    public List<String> strategyPreview() {
        return CronPatternUtils.preview((String)BpmnProperties.BPMN_DELETION_CRON, (int)10);
    }

    public TaskInstanceServiceImpl(TaskInstanceRepo taskInstanceRepo, TaskInstanceRepoProc taskInstanceRepoProc) {
        this.taskInstanceRepo = taskInstanceRepo;
        this.taskInstanceRepoProc = taskInstanceRepoProc;
    }
}

