package com.elitesland.cbpl.unicom.util;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;
import com.elitesland.cbpl.unicom.adapter.util.AdapterUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.unicom.context.Industry;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author eric.hao
 * @since 2022/03/21
 */
@Slf4j
@Component
public class TenantAdapter implements UnicomAdapter {

    private static final String ERR_TENANT_CONTEXT_CONFIG = "找不到租户的实施方案，请联系管理员";

    /**
     * 根据当前登录用户，找到租户对应的解决方案
     */
    @Override
    public Object filter(List<Object> providers) {
        Map<String, Object> clz = new HashMap<>();
        for (Object provider : providers) {
            UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
            clz.put(annotation.value(), provider);
        }
        // 1.优先执行定开版本代码
        Optional<Object> customizeProvider = AdapterUtil.matchCustomize(providers);
        if (customizeProvider.isPresent()) {
            log.debug("[PHOENIX-UNICOM] context provider: {}", customizeProvider.getClass().getSimpleName());
            return customizeProvider.get();
        }
        // 2. 再按租户配置的规则
        SysTenantDTO tenant = TenantClient.getSessionTenant();
        if (ObjectUtil.isNotNull(tenant)) {
            // 1.先找客户定制方案
            var customerProvider = clz.get(tenant.getCustomer());
            if (ObjectUtil.isNotNull(customerProvider)) {
                log.debug("[PHOENIX-UNICOM] context provider: {}", customerProvider.getClass().getSimpleName());
                return customerProvider;
            }

            // 2.再找行业方案
            var industryProvider = clz.get(tenant.getIndustry());
            if (ObjectUtil.isNotNull(industryProvider)) {
                log.debug("[PHOENIX-UNICOM] context provider: {}", industryProvider.getClass().getSimpleName());
                return industryProvider;
            }
        }
        // 3.最后执行标准方案
        var generalProvider = clz.get(Industry.INDUSTRY_GENERAL);
        if (ObjectUtil.isNull(generalProvider)) {
            throw new BusinessException(ERR_TENANT_CONTEXT_CONFIG);
        }
        log.debug("[PHOENIX-UNICOM] context provider: {}", generalProvider.getClass().getSimpleName());
        return generalProvider;
    }
}
