package com.elitesland.cbpl.cloudt.scheduling.config;

import com.elitesland.cbpl.cloudt.scheduling.service.ScheduleInitializeService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.scheduling.config.SchedulingProperties.SCHEDULE_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/06/03
 */
@Configuration
@ConditionalOnProperty(prefix = SCHEDULE_CONFIG_PREFIX, name = "enabled", havingValue = "true")
public class ScheduleInitializeSpiConfig {

    @Bean
    @ConditionalOnMissingBean
    public ScheduleInitializeService scheduleInitializeService() {
        return new ScheduleInitializeService();
    }
}
