package com.elitesland.cbpl.cloudt.logging.pipeline.cloudt.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.provider.SysThirdApiLogRpcService;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.infinity.domain.InfinityLogVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.map.MapUtils;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/07/09
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("CLOUDT")
public class CloudtPipelineService implements PipelineService {

    private final SysThirdApiLogRpcService logRpcService;

    @Override
    public boolean consume(LoggingProperty property, TrackDoc trackDoc) {
        try {
            ThirdApiLogDTO saveParam = saveParamToDO(trackDoc);
            if (ObjectUtil.isNotNull(saveParam)) {
                logRpcService.saveLog(saveParam);
            }
            return true;
        } catch (Throwable throwable) {
            log.error("[PHOENIX-LOG] persistence cloudt error", throwable);
        }
        return false;
    }

    @Override
    public PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        // do nothing.
        return new PagingVO<>();
    }

    @Override
    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        // do nothing.
        return ListUtil.empty();
    }

    @Override
    public List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query) {
        // do nothing.
        return ListUtil.empty();
    }

    private ThirdApiLogDTO saveParamToDO(TrackDoc trackDoc) {
        if (trackDoc == null) {
            return null;
        }
        if (!(trackDoc.getEventParam() instanceof InfinityLogVO)) {
            log.warn("[PHOENIX-LOG] 云梯日志暂时仅支持 ThirdApiLogDTO.class 参数");
            return null;
        }
        InfinityLogVO logVO = (InfinityLogVO) trackDoc.getEventParam();
        ThirdApiLogDTO logDTO = new ThirdApiLogDTO();
        logDTO.setAppCode("SRM");
        logDTO.setRestful(true);
        logDTO.setServer(false);
        logDTO.setServerAddr(logVO.getServerUrl()); // serverUrl
        logDTO.setThirdApp(logVO.getTargetApp());
        logDTO.setBusinessType(logVO.getBusinessType());
        logDTO.setBusinessKey(logVO.getBusinessKey());
        logDTO.setClientId("");
        logDTO.setUserId(SecurityContextUtil.currentUserId());
        logDTO.setUsername(SecurityContextUtil.currentUserName());
        logDTO.setUri(logVO.getApiUrl()); // apiUri
        logDTO.setReqMethod(logVO.getRequestMethod());
        logDTO.setReqQueryParams(MapUtils.convert(logVO.getQueryParam()));
        logDTO.setReqBody(BeanUtils.toJsonStr(logVO.getBodyParam()));
        logDTO.setReqHeaders(MapUtils.convert(logVO.getHeaderParam()));
        logDTO.setReqSuccess(logVO.getRequestSuccess());
        logDTO.setReqFailMsg(logVO.getRequestFailMessage());
        logDTO.setReqTime(DateUtil.parse(logVO.getRequestTime()).toLocalDateTime());
        logDTO.setReqIp(logVO.getAddressIp());
        logDTO.setRespBody(BeanUtils.toJsonStr(logVO.getResponseBody()));
        // TODO 响应内的错误码、错误信息，暂时以请求的状态一直
        logDTO.setRespSuccess(logVO.getRequestSuccess());
        logDTO.setRespFailMsg(logVO.getRequestFailMessage());
        logDTO.setRespTime(DateUtil.parse(logVO.getResponseTime()).toLocalDateTime());
        logDTO.setNeedRetry(false);
        logDTO.setDetectedOperatorAuth(false);
        return logDTO;
    }
}
