/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.logging.pipeline.cloudt.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.provider.SysThirdApiLogRpcService;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.infinity.domain.InfinityLogVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.map.MapUtils;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
@UnicomTag(value="CLOUDT")
public class CloudtPipelineService
implements PipelineService {
    private static final Logger log = LoggerFactory.getLogger(CloudtPipelineService.class);
    private final SysThirdApiLogRpcService logRpcService;

    public boolean consume(LoggingProperty property, TrackDoc trackDoc) {
        try {
            ThirdApiLogDTO saveParam = this.saveParamToDO(trackDoc);
            if (ObjectUtil.isNotNull((Object)saveParam)) {
                this.logRpcService.saveLog(saveParam);
            }
            return true;
        }
        catch (Throwable throwable) {
            log.error("[PHOENIX-LOG] persistence cloudt error", throwable);
            return false;
        }
    }

    public PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        return new PagingVO();
    }

    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        return ListUtil.empty();
    }

    public List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query) {
        return ListUtil.empty();
    }

    private ThirdApiLogDTO saveParamToDO(TrackDoc trackDoc) {
        if (trackDoc == null) {
            return null;
        }
        if (!(trackDoc.getEventParam() instanceof InfinityLogVO)) {
            log.warn("[PHOENIX-LOG] \u4e91\u68af\u65e5\u5fd7\u6682\u65f6\u4ec5\u652f\u6301 ThirdApiLogDTO.class \u53c2\u6570");
            return null;
        }
        InfinityLogVO logVO = (InfinityLogVO)trackDoc.getEventParam();
        ThirdApiLogDTO logDTO = new ThirdApiLogDTO();
        logDTO.setAppCode("SRM");
        logDTO.setRestful(Boolean.valueOf(true));
        logDTO.setServer(Boolean.valueOf(false));
        logDTO.setServerAddr(logVO.getServerUrl());
        logDTO.setThirdApp(logVO.getTargetApp());
        logDTO.setBusinessType(logVO.getBusinessType());
        logDTO.setBusinessKey(logVO.getBusinessKey());
        logDTO.setClientId("");
        logDTO.setUserId(SecurityContextUtil.currentUserId());
        logDTO.setUsername(SecurityContextUtil.currentUserName());
        logDTO.setUri(logVO.getApiUrl());
        logDTO.setReqMethod(logVO.getRequestMethod());
        logDTO.setReqQueryParams(MapUtils.convert((MultiValueMap)logVO.getQueryParam()));
        logDTO.setReqBody(BeanUtils.toJsonOrEmpty((Object)logVO.getBodyParam()));
        logDTO.setReqHeaders(MapUtils.convert((MultiValueMap)logVO.getHeaderParam()));
        logDTO.setReqSuccess(logVO.getRequestSuccess());
        logDTO.setReqFailMsg(logVO.getRequestFailMessage());
        logDTO.setReqTime(DateUtil.parse((CharSequence)logVO.getRequestTime()).toLocalDateTime());
        logDTO.setReqIp(logVO.getAddressIp());
        logDTO.setRespBody(BeanUtils.toJsonOrEmpty((Object)logVO.getResponseBody()));
        logDTO.setRespSuccess(logVO.getResponseSuccess());
        logDTO.setRespFailMsg(logVO.getResponseFailMessage());
        logDTO.setRespTime(DateUtil.parse((CharSequence)logVO.getResponseTime()).toLocalDateTime());
        logDTO.setNeedRetry(Boolean.valueOf(false));
        logDTO.setDetectedOperatorAuth(Boolean.valueOf(false));
        return logDTO;
    }

    public CloudtPipelineService(SysThirdApiLogRpcService logRpcService) {
        this.logRpcService = logRpcService;
    }
}

