package com.elitesland.cbpl.cloudt.bpmn.config;

import com.elitesland.cbpl.cloudt.bpmn.service.BpmnInitializeService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author eric.hao
 * @since 2024/06/03
 */
@Configuration
@ConditionalOnProperty(prefix = "liteflow", name = "enable", havingValue = "true")
public class BpmnInitializeSpiConfig {

    @Bean
    @ConditionalOnMissingBean
    public BpmnInitializeService bpmnInitializeService() {
        return new BpmnInitializeService();
    }
}
