package com.elitesland.cbpl.cloudt.tenant.annotation;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

import static com.elitesland.cbpl.tool.core.exceptions.TryCatch.tryWrapper;

/**
 * @author eric.hao
 * @since 2023/07/10
 */
@Aspect
@Slf4j
@Component
@RequiredArgsConstructor
public class TenantCallAspect {

    /**
     * 租户隔离工具类
     */
    @Resource
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    @Around(value = "@annotation(tenantCall)")
    public Object around(ProceedingJoinPoint point, TenantCall tenantCall) {
        String tenantCode = tenantCall.tenantCode();
        // 默认租户
        if (StrUtil.isBlank(tenantCode)) {
            return tenantDataIsolateProvider.byDefaultDirectly(() -> tryWrapper(point::proceed));
        }
        // 指定租户
        SysTenantDTO tenant = TenantClient.getTenant(tenantCode);
        return tenantDataIsolateProvider.byTenantDirectly(() -> tryWrapper(point::proceed), tenant);
    }
}
