/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.jpa.auditing;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.jpa.config.auditing.AuditCustomizer;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.cbpl.cloudt.iam.IamUserUtil;
import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomAuditService
implements AuditCustomizer {
    private static final Logger log = LoggerFactory.getLogger(CustomAuditService.class);
    private static TenantClientProvider tenantClientProvider;

    public void onCreate(Object source) {
        if (source instanceof BaseEntity) {
            BaseEntity entity = (BaseEntity)source;
            if (entity.getId() == null) {
                entity.setId(IdFactory.generateLong());
            }
            LocalDateTime now = entity.getCreateTime() == null ? LocalDateTime.now() : entity.getCreateTime();
            Long tenantId = entity.getTenantId() == null ? CustomAuditService.obtainTenantId() : entity.getTenantId();
            Long currentUserId = 0L;
            String currentUsername = null;
            if (IamUserUtil.isLogin()) {
                currentUserId = IamUserUtil.currentUserId();
                currentUsername = IamUserUtil.currentUserName();
            }
            if (entity.getCreateUserId() != null && CharSequenceUtil.isNotBlank((CharSequence)entity.getCreator())) {
                currentUserId = entity.getCreateUserId();
                currentUsername = entity.getCreator();
            }
            entity.setCreateUserId(currentUserId);
            entity.setCreator(currentUsername);
            entity.setCreateTime(now);
            if (entity.getModifyUserId() == null || CharSequenceUtil.isBlank((CharSequence)entity.getUpdater())) {
                entity.setModifyUserId(currentUserId);
                entity.setUpdater(currentUsername);
            }
            entity.setModifyTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)entity.getModifyTime(), (Object)now));
            entity.setDeleteFlag((Integer)ObjectUtil.defaultIfNull((Object)entity.getDeleteFlag(), (Object)0));
            entity.setTenantId(tenantId);
        }
    }

    public void onUpdate(Object source) {
        if (source instanceof BaseEntity) {
            BaseEntity entity = (BaseEntity)source;
            if (IamUserUtil.isLogin()) {
                entity.setModifyUserId(IamUserUtil.currentUserId());
                entity.setUpdater(IamUserUtil.currentUserName());
            }
            entity.setModifyTime(LocalDateTime.now());
            entity.setDeleteFlag((Integer)ObjectUtil.defaultIfNull((Object)entity.getDeleteFlag(), (Object)0));
        }
    }

    protected static Long obtainTenantId() {
        SysTenantDTO currentTenant = CustomAuditService.getTenantClientProvider().getSessionTenant();
        if (currentTenant != null) {
            return currentTenant.getId();
        }
        return TenantConstant.DEFAULT_TENANT_ID;
    }

    protected static TenantClientProvider getTenantClientProvider() {
        if (tenantClientProvider == null) {
            tenantClientProvider = (TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class);
        }
        return tenantClientProvider;
    }
}

