/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.online.registrar;

import com.elitescloud.boot.auth.BearerTokenAuthenticationToken;
import com.elitescloud.boot.auth.CommonAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;
import com.elitesland.cbpl.tool.websocket.spi.OnlineListener;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineRegistrar
implements OnlineListener {
    private static final Logger log = LoggerFactory.getLogger(OnlineRegistrar.class);
    private final OnlineService onlineService;

    public String getUserId(Principal principal) {
        if (principal == null) {
            return "G_9";
        }
        SysUserDTO user = this.getUser(principal);
        if (user != null) {
            return user.getId().toString();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", (Object)principal);
        return "G_9";
    }

    public String getUsername(Principal principal) {
        if (principal == null) {
            return "GUEST";
        }
        SysUserDTO user = this.getUser(principal);
        if (user != null) {
            return user.getUsername();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", (Object)principal);
        return "GUEST";
    }

    public String getNickname(Principal principal) {
        if (principal == null) {
            return "\u6e38\u5ba2";
        }
        SysUserDTO user = this.getUser(principal);
        if (user != null) {
            return user.getLastName();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", (Object)principal);
        return "\u6e38\u5ba2";
    }

    public void add(OnlineUser user) {
        this.onlineService.record(user);
    }

    public void remove(OnlineUser user) {
        this.onlineService.record(user);
    }

    private SysUserDTO getUser(Principal principal) {
        BearerTokenAuthenticationToken bearerTokenAuthenticationToken;
        CommonAuthenticationToken authenticationToken;
        if (principal instanceof CommonAuthenticationToken && (authenticationToken = (CommonAuthenticationToken)principal).getUserDetails() != null && authenticationToken.getUserDetails().getUser() != null) {
            return authenticationToken.getUserDetails().getUser();
        }
        if (principal instanceof BearerTokenAuthenticationToken && (bearerTokenAuthenticationToken = (BearerTokenAuthenticationToken)principal).getPrincipal() != null && ((GeneralUserDetails)bearerTokenAuthenticationToken.getPrincipal()).getUser() != null) {
            return ((GeneralUserDetails)bearerTokenAuthenticationToken.getPrincipal()).getUser();
        }
        return null;
    }

    public OnlineRegistrar(OnlineService onlineService) {
        this.onlineService = onlineService;
    }
}

