package com.elitesland.cbpl.cloudt.online.registrar;

import com.elitescloud.boot.auth.BearerTokenAuthenticationToken;
import com.elitescloud.boot.auth.CommonAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.tool.websocket.constant.WebSocketInstant;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;
import com.elitesland.cbpl.tool.websocket.spi.OnlineListener;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.security.Principal;

/**
 * @author eric.hao
 * @since 2024/11/21
 */
@Slf4j
@RequiredArgsConstructor
public class OnlineRegistrar implements OnlineListener {

    private final OnlineService onlineService;

    @Override
    public String getUserId(Principal principal) {
        if (principal == null) {
            return WebSocketInstant.GUEST_USER_ID;
        }
        // 云梯封装的用户上下文
        SysUserDTO user = getUser(principal);
        if (user != null) {
            return user.getId().toString();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", principal);
        return WebSocketInstant.GUEST_USER_ID;
    }

    @Override
    public String getUsername(Principal principal) {
        if (principal == null) {
            return WebSocketInstant.GUEST_USERNAME;
        }
        // 云梯封装的用户上下文
        SysUserDTO user = getUser(principal);
        if (user != null) {
            return user.getUsername();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", principal);
        return WebSocketInstant.GUEST_USERNAME;
    }

    @Override
    public String getNickname(Principal principal) {
        if (principal == null) {
            return WebSocketInstant.GUEST_NICKNAME;
        }
        // 云梯封装的用户上下文
        SysUserDTO user = getUser(principal);
        if (user != null) {
            return user.getLastName();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", principal);
        return WebSocketInstant.GUEST_NICKNAME;
    }

    @Override
    public String getTenantCode(Principal principal) {
        if (principal == null) {
            return WebSocketInstant.GUEST_TENANT_CODE;
        }
        // 云梯封装的用户上下文
        SysUserDTO user = getUser(principal);
        if (user != null && user.getSysTenantVO() != null) {
            return user.getSysTenantVO().getTenantCode();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", principal);
        return WebSocketInstant.GUEST_TENANT_CODE;
    }

    @Override
    public void add(OnlineUser user) {
        onlineService.record(user);
    }

    @Override
    public void remove(OnlineUser user) {
        onlineService.record(user);
    }

    /**
     * 云梯封装的用户上下文
     */
    private SysUserDTO getUser(Principal principal) {
        if (principal instanceof CommonAuthenticationToken) {
            CommonAuthenticationToken authenticationToken = (CommonAuthenticationToken) principal;
            if (authenticationToken.getUserDetails() != null && authenticationToken.getUserDetails().getUser() != null) {
                return authenticationToken.getUserDetails().getUser();
            }
        }
        if (principal instanceof BearerTokenAuthenticationToken) {
            BearerTokenAuthenticationToken bearerTokenAuthenticationToken = (BearerTokenAuthenticationToken) principal;
            if (bearerTokenAuthenticationToken.getPrincipal() != null &&
                    ((GeneralUserDetails) bearerTokenAuthenticationToken.getPrincipal()).getUser() != null) {
                return ((GeneralUserDetails) bearerTokenAuthenticationToken.getPrincipal()).getUser();
            }
        }
        return null;
    }
}
