/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.iam;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamUserUtil {
    private static final Logger log = LoggerFactory.getLogger(IamUserUtil.class);
    private static final Long DEFAULT_TENANT_ID = -1L;
    private static final String CURR_USER_ERROR = "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25";

    public static boolean isLogin() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        return !ObjectUtil.isNull((Object)user);
    }

    public static GeneralUserDetails currentUser() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (ObjectUtil.isNull((Object)user)) {
            throw new BusinessException(CURR_USER_ERROR);
        }
        return user;
    }

    public static String currentUserName() {
        String userName = SecurityContextUtil.currentUserName();
        if (StrUtil.isBlank((CharSequence)userName)) {
            throw new BusinessException(CURR_USER_ERROR);
        }
        return userName;
    }

    public static Long currentUserId() {
        Long userId = SecurityContextUtil.currentUserId();
        if (ObjectUtil.isNull((Object)userId)) {
            throw new BusinessException(CURR_USER_ERROR);
        }
        return userId;
    }

    public static String currentUserIdStr() {
        return String.valueOf(IamUserUtil.currentUserId());
    }

    public static Long currentTenantId() {
        SysTenantDTO tenant = IamUserUtil.currentTenant();
        return ObjectUtil.isNull((Object)tenant.getId()) ? DEFAULT_TENANT_ID : tenant.getId();
    }

    public static String currentTenantIdStr() {
        return String.valueOf(IamUserUtil.currentTenantId());
    }

    public static Long currentUserOuId() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (ObjectUtil.isNull((Object)user)) {
            throw new BusinessException(CURR_USER_ERROR);
        }
        return Optional.of(user).map(GeneralUserDetails::getUser).map(SysUserDTO::getOuId).orElse(0L);
    }

    public static SysTenantDTO currentTenant() {
        return TenantClient.getSessionTenant();
    }

    public static String currentTenantCode() {
        SysTenantDTO tenant = TenantClient.getSessionTenant();
        return ObjectUtil.isNull((Object)tenant) ? null : tenant.getTenantCode();
    }

    public static long currentTenantIdByCookie() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        Cookie[] cookies = request.getCookies();
        if (ObjectUtil.isNotNull((Object)cookies)) {
            List tokens = Arrays.stream(cookies).filter(cookie -> "token".equals(cookie.getName())).map(Cookie::getValue).collect(Collectors.toList());
            GeneralUserDetails user = CollUtil.isNotEmpty(tokens) ? SecurityContextUtil.convertToken((String)((String)tokens.get(0)).replace("Bearer%20", "")) : null;
            return Optional.ofNullable(user).map(GeneralUserDetails::getUser).map(SysUserDTO::getTenantId).orElse(DEFAULT_TENANT_ID);
        }
        return DEFAULT_TENANT_ID;
    }

    public static String currentToken() {
        return SecurityContextUtil.currentToken();
    }
}

