package com.elitesland.cbpl.cloudt.tenant.annotation;

import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.*;

/**
 * 解决接口或方法执行时，切换租户问题：外部API、定时任务
 *
 * @author eric.hao
 * @since 2023/07/10
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface TenantCall {

    /**
     * 为空值时，执行默认租户逻辑
     */
    @AliasFor("tenantCode")
    String value() default "";

    /**
     * 租户编码
     */
    @AliasFor("value")
    String tenantCode() default "";
}
