/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.online.registrar;

import com.corundumstudio.socketio.HandshakeData;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;
import com.elitesland.cbpl.tool.websocket.spi.OnlineListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineRegistrar
implements OnlineListener {
    private static final Logger log = LoggerFactory.getLogger(OnlineRegistrar.class);
    private final OnlineService onlineService;

    public String getUserId(HandshakeData request) {
        if (request == null) {
            return "G_9";
        }
        SysUserDTO user = this.getUser(request);
        if (user != null) {
            return user.getId().toString();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", (Object)request);
        return "G_9";
    }

    public String getUsername(HandshakeData request) {
        if (request == null) {
            return "GUEST";
        }
        SysUserDTO user = this.getUser(request);
        if (user != null) {
            return user.getUsername();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", (Object)request);
        return "GUEST";
    }

    public String getNickname(HandshakeData request) {
        if (request == null) {
            return "\u6e38\u5ba2";
        }
        SysUserDTO user = this.getUser(request);
        if (user != null) {
            return user.getLastName();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", (Object)request);
        return "\u6e38\u5ba2";
    }

    public String getTenantCode(HandshakeData request) {
        if (request == null) {
            return "-1";
        }
        SysUserDTO user = this.getUser(request);
        if (user != null && user.getSysTenantVO() != null) {
            return user.getSysTenantVO().getTenantCode();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", (Object)request);
        return "-1";
    }

    public void add(OnlineUser user) {
        this.onlineService.record(user);
    }

    public void remove(OnlineUser user) {
        this.onlineService.record(user);
    }

    private SysUserDTO getUser(HandshakeData request) {
        try {
            String token = request.getHttpHeaders().get("Authorization");
            if (token == null) {
                return null;
            }
            if (token.startsWith("Bearer ")) {
                token = token.substring(7);
            }
            GeneralUserDetails userDetails = SecurityContextUtil.convertToken((String)token);
            return userDetails.getUser();
        }
        catch (Exception e) {
            log.error("[PHOENIX-ONLINE] parse token error", (Throwable)e);
            return null;
        }
    }

    public OnlineRegistrar(OnlineService onlineService) {
        this.onlineService = onlineService;
    }
}

