package com.elitesland.cbpl.cloudt.iam;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.cbpl.unicom.domain.InvokeTag;
import com.elitesland.cbpl.web.iam.IamUserWeb;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2024/11/11
 */
@Slf4j
@Service
@UnicomTag(InvokeTag.TAG_GENERAL)
@RequiredArgsConstructor
public class IamUserService implements IamUserWeb {

    @Override
    public boolean isLogin() {
        return IamUserUtil.isLogin();
    }

    @Override
    public Long currentUserId() {
        return IamUserUtil.currentUserId();
    }

    @Override
    public String currentUserIdStr() {
        return IamUserUtil.currentUserIdStr();
    }

    @Override
    public Long currentTenantId() {
        return IamUserUtil.currentTenantId();
    }

    @Override
    public String currentTenantIdStr() {
        return IamUserUtil.currentTenantIdStr();
    }
}
