package com.elitesland.cbpl.cloudt.online.registrar;

import com.corundumstudio.socketio.HandshakeData;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.tool.websocket.constant.WebSocketConstant;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;
import com.elitesland.cbpl.tool.websocket.spi.OnlineListener;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * @author eric.hao
 * @since 2024/11/21
 */
@Slf4j
@RequiredArgsConstructor
public class OnlineRegistrar implements OnlineListener {

    private final OnlineService onlineService;

    @Override
    public String getUserId(HandshakeData request) {
        if (request == null) {
            return WebSocketConstant.GUEST_USER_ID;
        }
        // 云梯封装的用户上下文
        SysUserDTO user = getUser(request);
        if (user != null) {
            return user.getId().toString();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", request);
        return WebSocketConstant.GUEST_USER_ID;
    }

    @Override
    public String getUsername(HandshakeData request) {
        if (request == null) {
            return WebSocketConstant.GUEST_USERNAME;
        }
        // 云梯封装的用户上下文
        SysUserDTO user = getUser(request);
        if (user != null) {
            return user.getUsername();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", request);
        return WebSocketConstant.GUEST_USERNAME;
    }

    @Override
    public String getNickname(HandshakeData request) {
        if (request == null) {
            return WebSocketConstant.GUEST_NICKNAME;
        }
        // 云梯封装的用户上下文
        SysUserDTO user = getUser(request);
        if (user != null) {
            return user.getLastName();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", request);
        return WebSocketConstant.GUEST_NICKNAME;
    }

    @Override
    public String getTenantCode(HandshakeData request) {
        if (request == null) {
            return WebSocketConstant.GUEST_TENANT_CODE;
        }
        // 云梯封装的用户上下文
        SysUserDTO user = getUser(request);
        if (user != null && user.getSysTenantVO() != null) {
            return user.getSysTenantVO().getTenantCode();
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", request);
        return WebSocketConstant.GUEST_TENANT_CODE;
    }

    @Override
    public void add(OnlineUser user) {
        onlineService.record(user);
    }

    @Override
    public void remove(OnlineUser user) {
        onlineService.record(user);
    }

    /**
     * 云梯封装的用户上下文
     */
    private SysUserDTO getUser(HandshakeData request) {
        try {
            String token = request.getHttpHeaders().get("Authorization");
            if (token == null) {
                return null;
            }
            if (token.startsWith("Bearer ")) {
                token = token.substring(7);
            }
            var userDetails = SecurityContextUtil.convertToken(token);
            return userDetails.getUser();
        } catch (Exception e) {
            log.error("[PHOENIX-ONLINE] parse token error", e);
        }
        return null;
    }
}
