package com.elitesland.cbpl.cloudt.online.registrar;

import com.corundumstudio.socketio.HandshakeData;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.tool.websocket.constant.WebSocketConstant;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;
import com.elitesland.cbpl.tool.websocket.spi.OnlineListener;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.function.Function;

/**
 * @author eric.hao
 * @since 2024/11/21
 */
@Slf4j
@RequiredArgsConstructor
public class OnlineRegistrar implements OnlineListener {

    private final OnlineService onlineService;

    @Override
    public String getUserId(HandshakeData request) {
        return this.getAttr(request, (user) -> user.getId().toString(), WebSocketConstant.GUEST_USER_ID);
    }

    @Override
    public String getUsername(HandshakeData request) {
        return this.getAttr(request, SysUserDTO::getUsername, WebSocketConstant.GUEST_USERNAME);
    }

    @Override
    public String getNickname(HandshakeData request) {
        return this.getAttr(request, SysUserDTO::getLastName, WebSocketConstant.GUEST_NICKNAME);
    }

    @Override
    public String getTenantCode(HandshakeData request) {
        return this.getAttr(request, (user) -> {
            if (user.getSysTenantVO() != null) {
                return user.getSysTenantVO().getTenantCode();
            }
            return WebSocketConstant.GUEST_TENANT_CODE;
        }, WebSocketConstant.GUEST_TENANT_CODE);
    }

    @Override
    public void add(OnlineUser user) {
        onlineService.record(user);
    }

    @Override
    public void remove(OnlineUser user) {
        onlineService.record(user);
    }

    /**
     * 云梯封装的用户上下文
     */
    private SysUserDTO getUser(HandshakeData request) {
        try {
            String token = request.getHttpHeaders().get("Authorization");
            if (token == null) {
                return null;
            }
            if (token.startsWith("Bearer ")) {
                token = token.substring(7);
            }
            var userDetails = SecurityContextUtil.convertToken(token);
            if (userDetails == null) {
                log.error("[PHOENIX-ONLINE] token has expired.");
                return null;
            }
            return userDetails.getUser();
        } catch (Exception e) {
            log.error("[PHOENIX-ONLINE] parse token error", e);
        }
        return null;
    }

    /**
     * 获取用户属性
     */
    private String getAttr(HandshakeData request, Function<SysUserDTO, String> function, String defaultAttr) {
        if (request == null) {
            return defaultAttr;
        }
        // 云梯封装的用户上下文
        SysUserDTO user = getUser(request);
        if (user != null) {
            return function.apply(user);
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Principal Wrong: {}", request);
        return defaultAttr;
    }
}
