/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.tenant;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.tenant.client.support.impl.DefaultTenantProvider;
import com.elitescloud.cloudt.common.common.CloudtOptional;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;

public class TenantUtil {
    private static final ThreadLocal<SysTenantDTO> HAS_USED_TENANT = new ThreadLocal();
    private static final ThreadLocal<Boolean> HAS_USED_DEFAULT = new ThreadLocal();
    private static final ThreadLocal<Boolean> HAS_NOT = new ThreadLocal();

    public static SysTenantDTO setCurrentTenant(SysTenantDTO tenantDTO) {
        boolean hasNot = TenantSession.getNoTenant();
        if (hasNot) {
            TenantSession.clearNoTenant();
        }
        HAS_NOT.set(hasNot);
        HAS_USED_DEFAULT.set(TenantSession.getUseDefault());
        if (HAS_USED_DEFAULT.get().booleanValue()) {
            TenantSession.clearUseDefault();
        }
        HAS_USED_TENANT.set(TenantSession.getCurrentTenant());
        TenantSession.setCurrentTenant((SysTenantDTO)tenantDTO);
        return tenantDTO;
    }

    public static SysTenantDTO setCurrentTenant(Long tenantId) {
        DefaultTenantProvider tenantProvider = (DefaultTenantProvider)SpringUtil.getBean(DefaultTenantProvider.class);
        CloudtOptional tenantDTO = tenantProvider.getById(tenantId);
        return TenantUtil.setCurrentTenant((SysTenantDTO)tenantDTO.get());
    }

    public static SysTenantDTO setCurrentTenant(String tenantCode) {
        DefaultTenantProvider tenantProvider = (DefaultTenantProvider)SpringUtil.getBean(DefaultTenantProvider.class);
        CloudtOptional tenantDTO = tenantProvider.getByCode(tenantCode);
        return TenantUtil.setCurrentTenant((SysTenantDTO)tenantDTO.get());
    }

    public static void resetCurrentTenant() {
        if (HAS_USED_TENANT.get() == null) {
            TenantSession.clearCurrentTenant();
        } else {
            TenantSession.setCurrentTenant((SysTenantDTO)HAS_USED_TENANT.get());
        }
        HAS_USED_TENANT.remove();
        if (HAS_USED_DEFAULT.get().booleanValue()) {
            TenantSession.setUseDefault();
        }
        HAS_USED_DEFAULT.remove();
        if (HAS_NOT.get().booleanValue()) {
            TenantSession.setNoTenant();
        }
        HAS_NOT.remove();
    }
}

