/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.tenant.annotation;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.cbpl.cloudt.tenant.annotation.TenantCall;
import com.elitesland.cbpl.tool.core.exceptions.TryCatch;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TenantCallAspect {
    private static final Logger log = LoggerFactory.getLogger(TenantCallAspect.class);
    @Resource
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    @Around(value="@annotation(tenantCall)")
    public Object around(ProceedingJoinPoint point, TenantCall tenantCall) {
        String tenantCode = tenantCall.tenantCode();
        if (StrUtil.isBlank((CharSequence)tenantCode)) {
            return this.tenantDataIsolateProvider.byDefaultDirectly(() -> TryCatch.tryWrapper(() -> ((ProceedingJoinPoint)point).proceed()));
        }
        SysTenantDTO tenant = TenantClient.getTenant((String)tenantCode);
        return this.tenantDataIsolateProvider.byTenantDirectly(() -> TryCatch.tryWrapper(() -> ((ProceedingJoinPoint)point).proceed()), tenant);
    }
}

