package com.elitesland.cbpl.cloudt.tenant.spi;

import com.elitesland.cbpl.cloudt.tenant.TenantWrapper;
import com.elitesland.cbpl.tool.tenant.TenantAsyncSpi;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

/**
 * @author eric.hao
 * @since 2024/01/17
 */
@Slf4j
@RequiredArgsConstructor
public class CloudtTenantAsyncService implements TenantAsyncSpi {

    @Resource
    private TenantWrapper tenantWrapper;

    @Override
    public <T> CompletableFuture<T> supplyAsync(Supplier<T> executor, String tenantCode) {
        return tenantWrapper.supplyAsync(executor, tenantCode);
    }

    @Override
    public <T> CompletableFuture<Void> runAsync(Runnable executor, String tenantCode) {
        return tenantWrapper.runAsync(executor, tenantCode);
    }
}
