/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.online.registrar;

import com.corundumstudio.socketio.HandshakeData;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.cbpl.online.service.OnlineService;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;
import com.elitesland.cbpl.tool.websocket.spi.OnlineListener;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineRegistrar
implements OnlineListener {
    private static final Logger log = LoggerFactory.getLogger(OnlineRegistrar.class);
    private final OnlineService onlineService;

    public String getUserId(HandshakeData request) {
        return this.getAttr(request, user -> user.getId().toString(), "G_9");
    }

    public String getUsername(HandshakeData request) {
        return this.getAttr(request, SysUserDTO::getUsername, "GUEST");
    }

    public String getNickname(HandshakeData request) {
        return this.getAttr(request, SysUserDTO::getLastName, "\u6e38\u5ba2");
    }

    public String getTenantCode(HandshakeData request) {
        return this.getAttr(request, user -> {
            if (user.getSysTenantVO() != null) {
                return user.getSysTenantVO().getTenantCode();
            }
            return "-1";
        }, "-1");
    }

    public void add(OnlineUser user) {
        this.onlineService.record(user);
    }

    public void remove(OnlineUser user) {
        this.onlineService.record(user);
    }

    private SysUserDTO getUser(HandshakeData request) {
        try {
            GeneralUserDetails userDetails;
            String token = request.getHttpHeaders().get("Authorization");
            if (token == null) {
                return null;
            }
            if (token.startsWith("Bearer ")) {
                token = token.substring(7);
            }
            if ((userDetails = SecurityContextUtil.convertToken((String)token)) == null) {
                log.warn("[PHOENIX-ONLINE] token has expired.");
                return null;
            }
            return userDetails.getUser();
        }
        catch (Exception e) {
            log.error("[PHOENIX-ONLINE] parse token error", (Throwable)e);
            return null;
        }
    }

    private String getAttr(HandshakeData request, Function<SysUserDTO, String> function, String defaultAttr) {
        if (request == null) {
            return defaultAttr;
        }
        SysUserDTO user = this.getUser(request);
        if (user != null) {
            return function.apply(user);
        }
        log.warn("[PHOENIX-ONLINE] WebSocket Handshake Request: {}", (Object)BeanUtils.toJsonStr((Object)request));
        return defaultAttr;
    }

    public OnlineRegistrar(OnlineService onlineService) {
        this.onlineService = onlineService;
    }
}

