/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.scheduling.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.redis.common.RedisMessageSubscribe;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleActiveListener
implements RedisMessageSubscribe {
    private static final Logger log = LoggerFactory.getLogger(ScheduleActiveListener.class);
    private final ScheduleConfigRepoProc scheduleConfigRepoProc;
    @Autowired(required=false)
    private DefaultSchedulingRegistrar schedulingRegistrar;

    public String[] channel() {
        return new String[]{"sys_rosefinch_active"};
    }

    public <T extends Serializable> void onMessage(T t, String s) {
        log.info("receive schedule active message: {}\uff0c{}", t, (Object)s);
        ScheduleConfigDetailVO schedule = this.scheduleConfigRepoProc.findByRosefinchId((Long)t);
        if (ObjectUtil.isNotNull((Object)schedule)) {
            this.resetTriggerTask(SchedulingUtil.builder((ScheduleConfigDetailVO)schedule));
        }
    }

    private void resetTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.resetTriggerTask(task);
        }
    }

    public ScheduleActiveListener(ScheduleConfigRepoProc scheduleConfigRepoProc) {
        this.scheduleConfigRepoProc = scheduleConfigRepoProc;
    }
}

