package com.elitesland.cbpl.cloudt.online.config;

import com.elitesland.cbpl.cloudt.online.registrar.OnlineRegistrar;
import com.elitesland.cbpl.online.service.OnlineService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.tool.websocket.config.WebSocketProperties.WX_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/11/21
 */
@Slf4j
@Configuration
@ConditionalOnProperty(prefix = WX_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class OnlineCloudtAutoConfiguration {

    @Bean
    @ConditionalOnClass
    public OnlineRegistrar onlineRegistrar(OnlineService onlineService) {
        return new OnlineRegistrar(onlineService);
    }
}
