package com.elitesland.cbpl.cloudt.tenant.spi;

import com.elitesland.cbpl.cloudt.iam.IamUserUtil;
import com.elitesland.cbpl.cloudt.tenant.TenantUtil;
import com.elitesland.cbpl.cloudt.tenant.TenantWrapper;
import com.elitesland.cbpl.tool.tenant.TenantClientSpi;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.function.Supplier;

/**
 * @author eric.hao
 * @since 2024/01/18
 */
@Slf4j
@RequiredArgsConstructor
public class CloudtTenantClientService implements TenantClientSpi {

    @Resource
    private TenantWrapper tenantWrapper;

    @Override
    public void byTenants(Runnable executor) {
        tenantWrapper.byAllTenant(executor);
    }

    @Override
    public void byTenantDirectly(Runnable executor, String tenantCode) {
        tenantWrapper.byTenantDirectly(executor, tenantCode);
    }

    @Override
    public <E> E byTenantDirectly(Supplier<E> executor, String tenantCode) {
        return tenantWrapper.byTenantDirectly(executor, tenantCode);
    }

    @Override
    public void setCurrentTenant(Long tenantId) {
        TenantUtil.setCurrentTenant(tenantId);
    }

    @Override
    public void setCurrentTenant(String tenantCode) {
        TenantUtil.setCurrentTenant(tenantCode);
    }

    @Override
    public void resetCurrentTenant() {
        TenantUtil.resetCurrentTenant();
    }

    @Override
    public String currentTenantCode() {
        return IamUserUtil.currentTenantCode();
    }
}
