package com.elitesland.cbpl.cloudt.scheduling.config;

import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitesland.cbpl.cloudt.scheduling.service.ScheduleActiveListener;
import com.elitesland.cbpl.cloudt.scheduling.service.ScheduleInactiveListener;
import com.elitesland.cbpl.cloudt.scheduling.service.ScheduleInitializeService;
import com.elitesland.cbpl.cloudt.scheduling.service.ScheduleStatusService;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepoProc;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.scheduling.config.SchedulingProperties.SCHEDULE_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/06/03
 */
@Configuration
@ConditionalOnProperty(prefix = SCHEDULE_CONFIG_PREFIX, name = "enabled", havingValue = "true")
public class ScheduleInitializeSpiConfig {

    /**
     * 任务初始化检查
     */
    @Bean
    @ConditionalOnMissingBean
    public ScheduleInitializeService scheduleInitializeService() {
        return new ScheduleInitializeService();
    }

    /**
     * 状态监听接口
     */
    @Bean
    @ConditionalOnClass
    public ScheduleStatusService scheduleStatusService(RedisUtils redisUtil) {
        return new ScheduleStatusService(redisUtil);
    }

    /**
     * 通过Redis消息订阅，监听启用时触发
     */
    @Bean
    @ConditionalOnClass
    public ScheduleActiveListener scheduleActiveListener(ScheduleConfigRepoProc scheduleConfigRepoProc) {
        return new ScheduleActiveListener(scheduleConfigRepoProc);
    }

    /**
     * 通过Redis消息订阅，监听禁用时触发
     */
    @Bean
    @ConditionalOnClass
    public ScheduleInactiveListener scheduleInactiveListener(ScheduleConfigRepoProc scheduleConfigRepoProc) {
        return new ScheduleInactiveListener(scheduleConfigRepoProc);
    }
}
