package com.elitesland.cbpl.cloudt.formgenerator.config;

import com.elitesland.cbpl.cloudt.formgenerator.service.FormInitializeService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.formgenerator.config.FormgeneratorProperties.FORM_GENERATOR_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/06/03
 */
@Configuration
@ConditionalOnProperty(prefix = FORM_GENERATOR_CONFIG_PREFIX, name = "enabled", havingValue = "true")
public class FormInitializeSpiConfig {

    @Bean
    @ConditionalOnMissingBean
    public FormInitializeService formInitializeService() {
        return new FormInitializeService();
    }
}
