package com.elitesland.cbpl.cloudt.rosefinch.service;

import com.elitescloud.boot.redis.common.RedisMessageSubscribe;
import com.elitesland.cbpl.common.constant.SuccessTag;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.common.constant.InstanceStatus;
import com.elitesland.cbpl.rosefinch.constant.RosefinchConstant;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.proxy.domain.RosefinchMessage;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author eric.hao
 * @since 2025/01/20
 */
@Slf4j
@RequiredArgsConstructor
public class RosefinchStopListener implements RedisMessageSubscribe {

    private final RosefinchInstanceService instanceService;
    private final QueueHandlerService handlerService;

    @Override
    public String[] channel() {
        return new String[]{RosefinchConstant.InstanceChannel.INSTANCE_STOP};
    }

    @Override
    public <T extends Serializable> void onMessage(T t, String s) {
        log.info("receive rosefinch stop message: {}，{}", t, s);
        RosefinchMessage message = (RosefinchMessage) t;
        TenantSpiUtil.byTenantDirectly(() -> {
            try {
                var instance = instanceService.rosefinchInstanceById(message.getInstanceId());
                LogUtil.info(message.getTaskCode(), null, "[ROSEFINCH] 手动终止任务...", null, instance.getTraceId());
                // 立即终止
                boolean stopTag = handlerService.stopImmediately(instance);
                // 更新执行结果
                var saveParam = new RosefinchInstanceSaveParamVO();
                saveParam.setId(message.getInstanceId());
                saveParam.setEndTime(LocalDateTime.now());
                if (stopTag) {
                    saveParam.setInstanceStatus(InstanceStatus.STOP.getCode());
                }
                saveParam.setRemark("手动终止：" + SuccessTag.fromCode(stopTag));
                instanceService.update(saveParam);
                LogUtil.info(message.getTaskCode(), null, "[ROSEFINCH] 手动终止任务：" + SuccessTag.fromCode(stopTag), null, instance.getTraceId());
                return stopTag;
            } catch (Exception e) {
                LogUtil.error("[ROSEFINCH] 手动终止任务异常：", e);
                // 终止异常，按失败返回
                return false;
            }
        }, message.getTenantCode());
    }
}
