package com.elitesland.cbpl.cloudt.scheduling.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.redis.common.RedisMessageSubscribe;
import com.elitesland.cbpl.cloudt.scheduling.constant.ScheduleCloudtConstant;
import com.elitesland.cbpl.cloudt.scheduling.domain.ScheduleMessage;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2025/01/13
 */
@Slf4j
@RequiredArgsConstructor
public class ScheduleInactiveListener implements RedisMessageSubscribe {

    private final ScheduleConfigRepoProc scheduleConfigRepoProc;
    @Autowired(required = false)
    private DefaultSchedulingRegistrar schedulingRegistrar;

    @Override
    public String[] channel() {
        return new String[]{ScheduleCloudtConstant.SCHEDULE_INACTIVE_CHANNEL};
    }

    @Override
    public <T extends Serializable> void onMessage(T t, String s) {
        log.info("receive schedule inactive message: {}，{}", t, s);
        ScheduleMessage message = (ScheduleMessage) t;
        TenantSpiUtil.byTenantDirectly(() -> {
            var schedule = scheduleConfigRepoProc.findByRosefinchId(message.getRosefinchId());
            if (ObjectUtil.isNotNull(schedule)) {
                cancelTriggerTask(SchedulingUtil.builder(schedule));
            }
        }, message.getTenantCode());
    }

    /**
     * 取消定时任务 - 执行中的任务不强制终止
     */
    private void cancelTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull(schedulingRegistrar)) {
            schedulingRegistrar.cancelTriggerTask(task);
        }
    }
}
