package com.elitesland.cbpl.cloudt.scheduling.service;

import com.elitescloud.boot.SpringContextHolder;
import com.elitesland.cbpl.cloudt.tenant.TenantUtil;
import com.elitesland.cbpl.scheduling.spi.ScheduleInitializeSpi;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * @author eric.hao
 * @since 2024/06/03
 */
@Slf4j
@RequiredArgsConstructor
public class ScheduleInitializeService implements ScheduleInitializeSpi {

    /**
     * 云梯组件，是否加载完成
     */
    @Override
    public boolean initializeCompleted() {
        return SpringContextHolder.initialized() && TenantUtil.initializeCompleted();
    }
}
