package com.elitesland.cbpl.cloudt.scheduling.service;

import cn.hutool.core.collection.ListUtil;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitesland.cbpl.cloudt.iam.IamUserUtil;
import com.elitesland.cbpl.cloudt.scheduling.constant.ScheduleCloudtConstant;
import com.elitesland.cbpl.cloudt.scheduling.domain.ScheduleMessage;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigDetailVO;
import com.elitesland.cbpl.rosefinch.spi.RosefinchStatusListener;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

import static com.elitesland.cbpl.scheduling.constant.ScheduleTag.SCHEDULE_BUSINESS_TAG;
import static com.elitesland.cbpl.scheduling.constant.ScheduleTag.SCHEDULE_DELETION_TAG;

/**
 * @author eric.hao
 * @since 2024/08/13
 */
@Slf4j
@RequiredArgsConstructor
public class ScheduleStatusService implements RosefinchStatusListener {

    private final RedisUtils redisUtil;

    @Override
    public boolean supports(RosefinchConfigDetailVO rosefinchCfg) {
        List<String> status = ListUtil.of(SCHEDULE_BUSINESS_TAG, SCHEDULE_DELETION_TAG);
        return status.contains(rosefinchCfg.getTaskTag());
    }

    /**
     * 任务启用监听接口
     */
    @Override
    public void active(RosefinchConfigDetailVO rosefinchCfg) {
        redisUtil.publishMessage(ScheduleCloudtConstant.SCHEDULE_ACTIVE_CHANNEL, this.of(rosefinchCfg.getId()));
    }

    /**
     * 任务禁用监听接口
     */
    @Override
    public void inactive(RosefinchConfigDetailVO rosefinchCfg) {
        redisUtil.publishMessage(ScheduleCloudtConstant.SCHEDULE_INACTIVE_CHANNEL, this.of(rosefinchCfg.getId()));
    }

    private ScheduleMessage of(Long rosefinchId) {
        ScheduleMessage message = new ScheduleMessage();
        message.setRosefinchId(rosefinchId);
        message.setTenantCode(IamUserUtil.currentTenantCode());
        return message;
    }
}
