/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.jpa.auditing;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.boot.jpa.config.auditing.AuditCustomizer;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomAuditService
implements AuditCustomizer {
    private static final Logger log = LoggerFactory.getLogger(CustomAuditService.class);
    private static TenantClientProvider tenantClientProvider;
    private static UserDetailProvider userProvider;

    public void onCreate(Object source) {
        if (source instanceof BaseEntity) {
            BaseEntity entity = (BaseEntity)source;
            if (entity.getId() == null) {
                entity.setId(IdFactory.generateLong());
            }
            LocalDateTime now = entity.getCreateTime() == null ? LocalDateTime.now() : entity.getCreateTime();
            Long tenantId = entity.getTenantId() == null ? CustomAuditService.obtainTenantId() : entity.getTenantId();
            GeneralUserDetails user = CustomAuditService.currentUser();
            Long currentUserId = 0L;
            String currentUsername = null;
            if (user != null && user.getUser() != null) {
                currentUserId = user.getUserId();
                currentUsername = CustomAuditService.obtainCurrentUserName(user);
            }
            if (entity.getCreateUserId() != null && CharSequenceUtil.isNotBlank((CharSequence)entity.getCreator())) {
                currentUserId = entity.getCreateUserId();
                currentUsername = entity.getCreator();
            }
            entity.setCreateUserId(currentUserId);
            entity.setCreator(currentUsername);
            entity.setCreateTime(now);
            if (entity.getModifyUserId() == null || CharSequenceUtil.isBlank((CharSequence)entity.getUpdater())) {
                entity.setModifyUserId(currentUserId);
                entity.setUpdater(currentUsername);
            }
            entity.setModifyTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)entity.getModifyTime(), (Object)now));
            entity.setDeleteFlag((Integer)ObjectUtil.defaultIfNull((Object)entity.getDeleteFlag(), (Object)0));
            entity.setTenantId(tenantId);
        }
    }

    public void onUpdate(Object source) {
        if (source instanceof BaseEntity) {
            BaseEntity entity = (BaseEntity)source;
            GeneralUserDetails user = CustomAuditService.currentUser();
            if (user != null && user.getUser() != null) {
                entity.setModifyUserId(user.getUserId());
                entity.setUpdater(CustomAuditService.obtainCurrentUserName(user));
            }
            entity.setModifyTime(LocalDateTime.now());
            entity.setDeleteFlag((Integer)ObjectUtil.defaultIfNull((Object)entity.getDeleteFlag(), (Object)0));
        }
    }

    protected static String obtainCurrentUserName(GeneralUserDetails currentUser) {
        if (currentUser == null) {
            currentUser = CustomAuditService.currentUser();
        }
        if (currentUser == null) {
            return null;
        }
        return currentUser.getUser().getPrettyName();
    }

    protected static Long obtainTenantId() {
        SysTenantDTO currentTenant = CustomAuditService.getTenantClientProvider().getSessionTenant();
        if (currentTenant != null) {
            return currentTenant.getId();
        }
        return TenantConstant.DEFAULT_TENANT_ID;
    }

    protected static Long obtainTenantOrgId() {
        Boolean useTenantOrg = TenantOrgContext.isUseTenantOrg();
        if (!((Boolean)ObjectUtil.defaultIfNull((Object)useTenantOrg, (Object)true)).booleanValue()) {
            return null;
        }
        return TenantOrgContext.getTenantOrg();
    }

    protected static GeneralUserDetails currentUser() {
        if (userProvider == null) {
            userProvider = (UserDetailProvider)SpringContextHolder.getBean(UserDetailProvider.class);
        }
        return userProvider.currentUser();
    }

    protected static TenantClientProvider getTenantClientProvider() {
        if (tenantClientProvider == null) {
            tenantClientProvider = (TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class);
        }
        return tenantClientProvider;
    }
}

