package com.elitesland.cbpl.cloudt.rosefinch.config;

import com.elitesland.cbpl.cloudt.rosefinch.service.RosefinchStopListener;
import com.elitesland.cbpl.rosefinch.config.RosefinchProperties;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.dromara.dynamictp.core.spring.EnableDynamicTp;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.rosefinch.config.RosefinchProperties.ROSEFINCH_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2025/01/20
 */
@Slf4j
@EnableDynamicTp
@Configuration
@EnableConfigurationProperties(RosefinchProperties.class)
@ConditionalOnProperty(prefix = ROSEFINCH_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class RosefinchCloudtConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public RosefinchStopListener rosefinchStopListener(
            RosefinchInstanceService rosefinchInstanceService, QueueHandlerService queueHandlerService) {
        return new RosefinchStopListener(rosefinchInstanceService, queueHandlerService);
    }
}
