/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.scheduling.config;

import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitesland.cbpl.cloudt.scheduling.service.ScheduleActiveListener;
import com.elitesland.cbpl.cloudt.scheduling.service.ScheduleInactiveListener;
import com.elitesland.cbpl.cloudt.scheduling.service.ScheduleInitializeService;
import com.elitesland.cbpl.cloudt.scheduling.service.ScheduleStatusService;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepoProc;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="cbpl.schedule", name={"enabled"}, havingValue="true")
public class ScheduleInitializeSpiConfig {
    @Bean
    @ConditionalOnMissingBean
    public ScheduleInitializeService scheduleInitializeService() {
        return new ScheduleInitializeService();
    }

    @Bean
    @ConditionalOnClass
    public ScheduleStatusService scheduleStatusService(RedisUtils redisUtil) {
        return new ScheduleStatusService(redisUtil);
    }

    @Bean
    @ConditionalOnClass
    public ScheduleActiveListener scheduleActiveListener(ScheduleConfigRepoProc scheduleConfigRepoProc) {
        return new ScheduleActiveListener(scheduleConfigRepoProc);
    }

    @Bean
    @ConditionalOnClass
    public ScheduleInactiveListener scheduleInactiveListener(ScheduleConfigRepoProc scheduleConfigRepoProc) {
        return new ScheduleInactiveListener(scheduleConfigRepoProc);
    }
}

