/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.scheduling.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.redis.common.RedisMessageSubscribe;
import com.elitesland.cbpl.cloudt.scheduling.domain.ScheduleMessage;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleInactiveListener
implements RedisMessageSubscribe {
    private static final Logger log = LoggerFactory.getLogger(ScheduleInactiveListener.class);
    private final ScheduleConfigRepoProc scheduleConfigRepoProc;
    @Autowired(required=false)
    private DefaultSchedulingRegistrar schedulingRegistrar;

    public String[] channel() {
        return new String[]{"sys_rosefinch_inactive"};
    }

    public <T extends Serializable> void onMessage(T t, String s) {
        log.info("receive schedule inactive message: {}\uff0c{}", t, (Object)s);
        ScheduleMessage message = (ScheduleMessage)t;
        TenantSpiUtil.byTenantDirectly(() -> {
            ScheduleConfigDetailVO schedule = this.scheduleConfigRepoProc.findByRosefinchId(message.getRosefinchId());
            if (ObjectUtil.isNotNull((Object)schedule)) {
                this.cancelTriggerTask(SchedulingUtil.builder((ScheduleConfigDetailVO)schedule));
            }
        }, (String)message.getTenantCode());
    }

    private void cancelTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.cancelTriggerTask(task);
        }
    }

    public ScheduleInactiveListener(ScheduleConfigRepoProc scheduleConfigRepoProc) {
        this.scheduleConfigRepoProc = scheduleConfigRepoProc;
    }
}

