/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.rosefinch.service;

import com.elitescloud.boot.redis.common.RedisMessageSubscribe;
import com.elitesland.cbpl.common.constant.SuccessTag;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.client.queue.producer.manager.InstanceManager;
import com.elitesland.cbpl.rosefinch.common.constant.InstanceStatus;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceDetailVO;
import com.elitesland.cbpl.rosefinch.proxy.domain.RosefinchMessage;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosefinchStopListener
implements RedisMessageSubscribe {
    private static final Logger log = LoggerFactory.getLogger(RosefinchStopListener.class);
    private final RosefinchInstanceService instanceService;
    private final QueueHandlerService handlerService;

    public String[] channel() {
        return new String[]{"instance_stop_channel"};
    }

    public <T extends Serializable> void onMessage(T t, String s) {
        RosefinchMessage message = (RosefinchMessage)t;
        if (!InstanceManager.pendingContains((String)message.getTaskCode(), (Long)message.getInstanceId())) {
            log.warn("[ROSEFINCH] Not running on this node: {}\uff0c{}", t, (Object)s);
            return;
        }
        TenantSpiUtil.byTenantDirectly(() -> {
            try {
                RosefinchInstanceDetailVO instance = this.instanceService.rosefinchInstanceById(message.getInstanceId());
                LogUtil.info((String)message.getTaskCode(), null, (String)"[ROSEFINCH] \u624b\u52a8\u7ec8\u6b62\u4efb\u52a1...", null, (String)instance.getTraceId());
                boolean stopTag = this.handlerService.stopImmediately(instance);
                RosefinchInstanceSaveParamVO saveParam = new RosefinchInstanceSaveParamVO();
                saveParam.setId(message.getInstanceId());
                saveParam.setEndTime(LocalDateTime.now());
                if (stopTag) {
                    saveParam.setInstanceStatus(InstanceStatus.STOP.getCode());
                }
                saveParam.setRemark("\u624b\u52a8\u7ec8\u6b62\uff1a" + SuccessTag.fromCode((boolean)stopTag));
                this.instanceService.update(saveParam);
                LogUtil.info((String)message.getTaskCode(), null, (String)("[ROSEFINCH] \u624b\u52a8\u7ec8\u6b62\u4efb\u52a1\uff1a" + SuccessTag.fromCode((boolean)stopTag)), null, (String)instance.getTraceId());
                return stopTag;
            }
            catch (Exception e) {
                LogUtil.error((String)"[ROSEFINCH] \u624b\u52a8\u7ec8\u6b62\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
                return false;
            }
        }, (String)message.getTenantCode());
    }

    public RosefinchStopListener(RosefinchInstanceService instanceService, QueueHandlerService handlerService) {
        this.instanceService = instanceService;
        this.handlerService = handlerService;
    }
}

