package com.elitesland.cbpl.data.etl.config;

import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.data.etl.config.DataCleanProperties.DATA_CLEAN_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/05/06
 */
@Data
@ConfigurationProperties(prefix = DATA_CLEAN_CONFIG_PREFIX)
public class DataCleanProperties implements InitializingBean {

    public static final String DATA_CLEAN_CONFIG_PREFIX = "cbpl.data.etl";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    public static boolean DATA_ETL_ENABLED;

    @Override
    public void afterPropertiesSet() throws Exception {
        DATA_ETL_ENABLED = enabled;
    }
}
