package com.elitesland.cbpl.data.etl.controller;

import com.elitesland.cbpl.data.etl.util.DataETL;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author eric.hao
 * @since 2024/05/06
 */
@Slf4j
@RestController
@RequestMapping("/demo/etl")
@RequiredArgsConstructor
public class DataCleanDemoController {

    @PostMapping("/transform")
    public HttpResult<?> transform(String templateCode, @RequestBody Object data) {
        String result = DataETL.transform(templateCode, data);
        return HttpResult.ok(BeanUtils.toMap(result));
    }
}
