package com.elitesland.cbpl.data.etl.transform.template.vo.param;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * ETL-转换模板表
 *
 * @author eric.hao
 * @since 2024/05/06
 */
@Data
@ApiModel("ETL-转换模板表")
public class TemplateSaveParamVO {

	@ApiModelProperty(value = "记录唯一ID")
	private Long id;

	@ApiModelProperty(value = "模版编码")
	private String templateCode;

	@ApiModelProperty(value = "模版名称")
	private String templateName;

	@ApiModelProperty(value = "消息内容标题(Velocity)")
	private String subject;

	@ApiModelProperty(value = "消息内容模板(Velocity)")
	private String content;

	@ApiModelProperty(value = "备注")
	private String remark;
	public boolean isNew() {
		return ObjectUtil.isNull(id);
	}
}
