package com.elitesland.cbpl.data.etl.transform.template.vo.resp;

import com.elitesland.cbpl.data.etl.transform.template.domain.TemplateStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * ETL-转换模板表
 *
 * @author eric.hao
 * @since 2024/05/06
 */
@Data
@ApiModel("ETL-转换模板表")
public class TemplatePagingVO implements Serializable {

	private static final long serialVersionUID = 8471157729528666765L;

	@ApiModelProperty(value = "记录唯一ID")
	private Long id;

	@ApiModelProperty(value = "模版编码")
	private String templateCode;

	@ApiModelProperty(value = "模版名称")
	private String templateName;

	@ApiModelProperty(value = "状态：0禁用；1启用；")
	private Integer status;

	@JsonProperty
	public String getStatusName() {
		return TemplateStatus.fromCode(status);
	}

//	@ApiModelProperty(value = "消息内容标题(Velocity)")
//	private String subject;
//
//	@ApiModelProperty(value = "消息内容模板(Velocity)")
//	private String content;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "记录创建者ID")
	private Long createUserId;

	@ApiModelProperty(value = "记录创建者")
	private String creator;

	@ApiModelProperty(value = "记录创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "记录最后更新者ID")
	private Long modifyUserId;

	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	@ApiModelProperty(value = "记录最后更新时间")
	private LocalDateTime modifyTime;
}
