package com.elitesland.cbpl.data.etl.transform.util;

import cn.hutool.json.JSONUtil;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import lombok.extern.slf4j.Slf4j;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

import java.io.StringWriter;

/**
 * @author eric.hao
 * @since 2024/05/06
 */
@Slf4j
public class TransformUtil {

    private static VelocityEngine velocityEngine;
    private static VelocityEngine getInstance() {
        if (velocityEngine == null) {
            velocityEngine = new VelocityEngine();
            velocityEngine.init();
        }
        return velocityEngine;
    }

    /**
     * 使用模板
     *
     * @param context  上下文
     * @param logTag   日志标签，报错排查问题时需要
     * @param inString 模板
     * @return 解析后数据
     */
    public static String parse(VelocityContext context, String logTag, String inString) {
        StringWriter out = new StringWriter();
        boolean result = getInstance().evaluate(context, out, logTag, inString);
        if (!result) {
            logger.error("[PHOENIX-ETL] transform error: {}, {}, {}", logTag, inString, context);
            throw PhoenixException.unchecked("transform error.");
        }
        return JSONUtil.toJsonPrettyStr(out.toString());
    }
}
