/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.data.etl.transform.template.service.impl;

import com.elitesland.cbpl.data.etl.transform.template.convert.TransformTemplateConvert;
import com.elitesland.cbpl.data.etl.transform.template.entity.TransformTemplateDO;
import com.elitesland.cbpl.data.etl.transform.template.repo.TransformTemplateRepo;
import com.elitesland.cbpl.data.etl.transform.template.repo.TransformTemplateRepoProc;
import com.elitesland.cbpl.data.etl.transform.template.service.TransformTemplateService;
import com.elitesland.cbpl.data.etl.transform.template.vo.param.TemplatePagingParamVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.param.TemplateSaveParamVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.resp.TemplatePagingVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.resp.TransformTemplateVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransformTemplateServiceImpl
implements TransformTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(TransformTemplateServiceImpl.class);
    private final TransformTemplateRepo templateRepo;
    private final TransformTemplateRepoProc templateRepoProc;

    @Override
    public PagingVO<TemplatePagingVO> transformTemplatePageBy(TemplatePagingParamVO query) {
        long count = this.templateRepoProc.transformTemplateCountBy(query);
        if (count > 0L) {
            List<TemplatePagingVO> list = this.templateRepoProc.transformTemplatePageBy(query);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public TransformTemplateVO transformTemplateById(Long id) {
        Optional templateDO = this.templateRepo.findById(id);
        if (templateDO.isEmpty()) {
            throw PhoenixException.unexpected((String)("[PHOENIX-ETL] TemplateId(" + id + ") Not Found"));
        }
        return TransformTemplateConvert.INSTANCE.doToVO((TransformTemplateDO)templateDO.get());
    }

    @Override
    public TransformTemplateVO transformTemplateByCode(String templateCode) {
        Optional<TransformTemplateDO> templateDO = this.templateRepo.findByTemplateCode(templateCode);
        if (templateDO.isEmpty()) {
            throw PhoenixException.unexpected((String)("[PHOENIX-ETL] TemplateCode(" + templateCode + ") Not Found"));
        }
        return TransformTemplateConvert.INSTANCE.doToVO(templateDO.get());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(TemplateSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            TransformTemplateDO templateDO = TransformTemplateConvert.INSTANCE.saveParamToDO(saveParam);
            templateDO.setStatus(1);
            this.templateRepo.save(templateDO);
            return templateDO.getId();
        }
        Optional templateDO = this.templateRepo.findById(saveParam.getId());
        if (templateDO.isEmpty()) {
            throw PhoenixException.unexpected((String)("[PHOENIX-ETL] TemplateId(" + saveParam.getId() + ") Not Found"));
        }
        TransformTemplateDO template = (TransformTemplateDO)templateDO.get();
        TransformTemplateConvert.INSTANCE.saveParamMergeToDO(saveParam, template);
        this.templateRepo.save(template);
        return template.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(Long id, Integer status) {
        this.templateRepoProc.updateStatus(id, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long delete(List<Long> ids) {
        return this.templateRepoProc.delete(ids);
    }

    public TransformTemplateServiceImpl(TransformTemplateRepo templateRepo, TransformTemplateRepoProc templateRepoProc) {
        this.templateRepo = templateRepo;
        this.templateRepoProc = templateRepoProc;
    }
}

