/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.data.etl.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.data.etl.config.DataCleanProperties;
import com.elitesland.cbpl.data.etl.transform.template.service.TransformTemplateService;
import com.elitesland.cbpl.data.etl.transform.template.service.impl.TransformTemplateServiceImpl;
import com.elitesland.cbpl.data.etl.transform.template.vo.resp.TransformTemplateVO;
import com.elitesland.cbpl.data.etl.transform.util.TransformUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataETL {
    private static final Logger logger = LoggerFactory.getLogger(DataETL.class);
    private static TransformTemplateService templateService;

    private static TransformTemplateService getTemplateInstance() {
        if (templateService == null) {
            templateService = (TransformTemplateService)SpringUtil.getBean(TransformTemplateServiceImpl.class);
        }
        return templateService;
    }

    public static String transform(String templateCode, Object data) {
        if (!DataCleanProperties.DATA_ETL_ENABLED) {
            logger.warn("[PHOENIX-ETL] data-etl not enabled.");
            return BeanUtils.toJsonStr((Object)data);
        }
        TransformTemplateVO template = DataETL.getTemplateInstance().transformTemplateByCode(templateCode);
        if (!template.available()) {
            throw PhoenixException.unchecked((String)("[PHOENIX-ETL] template(" + templateCode + ") not available."));
        }
        VelocityContext context = new VelocityContext();
        context.put("ctx", data);
        return TransformUtil.parse(context, template.getTemplateCode(), template.getContent());
    }

    public static <T> T transform(String templateCode, Object data, Class<T> clazz) {
        String transform = DataETL.transform(templateCode, data);
        return (T)BeanUtils.toBean((String)transform, clazz);
    }

    public static <T> T transform(String templateCode, Object data, TypeReference<T> typeRef) {
        String transform = DataETL.transform(templateCode, data);
        return (T)BeanUtils.toBean((String)transform, typeRef);
    }
}

