package com.elitesland.cbpl.data.etl.transform.template.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.*;
import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;

/**
 * ETL-转换模板表
 *
 * @author eric.hao
 * @since 2024/05/06
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_etl_transform_template")
@org.hibernate.annotations.Table(appliesTo = "sys_etl_transform_template", comment = "ETL-转换模板表")
@ApiModel("ETL-转换模板表")
public class TransformTemplateDO extends BaseEntity implements Serializable {

	private static final long serialVersionUID = 7858107086625543691L;

	/**
	 * 模版编码
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "模版编码")
	@Column(name = "template_code", nullable = true, length = 64)
	private String templateCode;

	/**
	 * 模版名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "模版名称")
	@Column(name = "template_name", nullable = true, length = 64)
	private String templateName;

	/**
	 * 状态：0禁用；1启用；
	 * nullable : true
	 * default  : 1
	 */
	@ApiModelProperty(value = "状态：0禁用；1启用；")
	@Column(name = "status", nullable = true, length = 11)
	private Integer status;

	/**
	 * 消息内容标题(Velocity)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "消息内容标题(Velocity)")
	@Column(name = "subject", nullable = true, length = 255)
	private String subject;

	/**
	 * 消息内容模板(Velocity)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "消息内容模板(Velocity)")
	@Column(name = "content", nullable = true)
	private String content;
}
