package com.elitesland.cbpl.data.etl.transform.template.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.data.etl.transform.template.entity.QTransformTemplateDO;
import com.elitesland.cbpl.data.etl.transform.template.vo.param.TemplatePagingParamVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.resp.TemplatePagingVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/06
 */
@Component
@RequiredArgsConstructor
public class TransformTemplateRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QTransformTemplateDO transformTemplateDO = QTransformTemplateDO.transformTemplateDO;

    private final QBean<TemplatePagingVO> transformTemplatePagingVO = Projections.bean(
            TemplatePagingVO.class,
            transformTemplateDO.id,
            transformTemplateDO.templateCode,
            transformTemplateDO.templateName,
            transformTemplateDO.status,
//            transformTemplateDO.subject,
//            transformTemplateDO.content,
            transformTemplateDO.remark,
            transformTemplateDO.createUserId,
            transformTemplateDO.creator,
            transformTemplateDO.createTime,
            transformTemplateDO.modifyUserId,
            transformTemplateDO.updater,
            transformTemplateDO.modifyTime
    );

    private Predicate pagingWhere(TemplatePagingParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(transformTemplateDO.deleteFlag.eq(0));
        if (StrUtil.isNotBlank(query.getTemplateCode())) {
            predicates.add(transformTemplateDO.templateCode.eq(query.getTemplateCode()));
        }
        if (StrUtil.isNotBlank(query.getTemplateName())) {
            String likeStr = SqlUtil.toSqlLikeString(query.getTemplateName());
            predicates.add(transformTemplateDO.templateName.like(likeStr));
        }
        if (ObjectUtil.isNotNull(query.getStatus())) {
            predicates.add(transformTemplateDO.status.eq(query.getStatus()));
        }
//        if (StrUtil.isNotBlank(query.getSubject())) {
//            predicates.add(transformTemplateDO.subject.eq(query.getSubject()));
//        }
//        if (StrUtil.isNotBlank(query.getContent())) {
//            predicates.add(transformTemplateDO.content.eq(query.getContent()));
//        }
        if (StrUtil.isNotBlank(query.getRemark())) {
            predicates.add(transformTemplateDO.remark.eq(query.getRemark()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long transformTemplateCountBy(TemplatePagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(transformTemplateDO.id)
                .from(transformTemplateDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<TemplatePagingVO> transformTemplatePageBy(TemplatePagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(transformTemplatePagingVO)
                .from(transformTemplateDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, transformTemplateDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    public long delete(List<Long> ids) {
        JPADeleteClause delete = jpaQueryFactory.delete(transformTemplateDO)
                .where(transformTemplateDO.id.in(ids));
        return delete.execute();
    }

    public long updateStatus(Long id, Integer status) {
        JPAUpdateClause update = jpaQueryFactory.update(transformTemplateDO)
                .set(transformTemplateDO.status, status)
                .where(transformTemplateDO.id.eq(id));
        return update.execute();
    }
}
