package com.elitesland.cbpl.data.etl.transform.template.service;

import com.elitesland.cbpl.data.etl.transform.template.vo.resp.TransformTemplateVO;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.param.TemplatePagingParamVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.param.TemplateSaveParamVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.resp.TemplatePagingVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/06
 */
public interface TransformTemplateService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<TemplatePagingVO> transformTemplatePageBy(TemplatePagingParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    TransformTemplateVO transformTemplateById(Long id);

    /**
     * 明细查询
     *
     * @param templateCode 业务单据编码
     * @return 明细数据
     */
    TransformTemplateVO transformTemplateByCode(String templateCode);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(TemplateSaveParamVO saveParam);

    /**
     * 更新状态
     *
     * @param id     业务单据ID
     * @param status 更新状态
     */
    void updateStatus(Long id, Integer status);

    /**
     * 批量物理删除
     *
     * @param ids 业务单据ID
     * @return 删除成功的数量
     */
    long delete(List<Long> ids);
}
