package com.elitesland.cbpl.data.etl.util;

import cn.hutool.core.date.DatePattern;
import com.elitesland.cbpl.tool.core.date.DateUtils;

/**
 * @author eric.hao
 * @version 0.1.3-SNAPSHOT
 * @since 2024/07/04
 */
public class DateFormat {

    /**
     * 当前时间
     *
     * @return 格式字符串 yyyy-MM-dd HH:mm:ss
     */
    public String now() {
        return DateUtils.nowStr();
    }

    /**
     * 根据特定格式格式化日期
     *
     * @param format  日期格式，常用格式见： {@link DatePattern} {@link DatePattern#NORM_DATETIME_PATTERN}
     * @param dateStr 被格式化的日期字符串
     * @return 格式化后的字符串
     */
    public String format(String format, String dateStr) {
        return DateUtils.format(dateStr, format);
    }

    /**
     * 当前时间，可以指定格式
     *
     * @param format 日期格式，常用格式见： {@link DatePattern} {@link DatePattern#NORM_DATETIME_PATTERN}
     * @return 格式字符串 yyyy-MM-dd HH:mm:ss
     */
    public String now(String format) {
        return DateUtils.format(now(), format);
    }
}
