package com.elitesland.cbpl.data.etl.config;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.data.etl.config.DataCleanProperties.DATA_CLEAN_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/05/06
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(DataCleanProperties.class)
@ConditionalOnProperty(prefix = DATA_CLEAN_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class DataCleanAutoConfiguration {

}
