package com.elitesland.cbpl.data.etl.transform.template.convert;

import com.elitesland.cbpl.data.etl.transform.template.entity.TransformTemplateDO;
import com.elitesland.cbpl.data.etl.transform.template.vo.param.TemplateSaveParamVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.resp.TransformTemplateVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2024/05/06
 */
@Mapper(config = BaseMapperConfig.class)
public interface TransformTemplateConvert {

	TransformTemplateConvert INSTANCE = Mappers.getMapper(TransformTemplateConvert.class);

    /**
     * DO => RespVO
     */
    TransformTemplateVO doToVO(TransformTemplateDO transformTemplateDO);

    /**
     * SaveParam => DO
     */
    TransformTemplateDO saveParamToDO(TemplateSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(TemplateSaveParamVO saveParam, @MappingTarget TransformTemplateDO transformTemplateDO);
}
