package com.elitesland.cbpl.data.etl.transform.template.vo.resp;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * ETL-转换模板表
 *
 * @author eric.hao
 * @since 2024/05/06
 */
@Data
@ApiModel("ETL-转换模板表")
public class TransformTemplateVO {

    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "模版编码")
    private String templateCode;

    @ApiModelProperty(value = "模版名称")
    private String templateName;

    @ApiModelProperty(value = "状态：0禁用；1启用；")
    private Integer status;

    @ApiModelProperty(value = "消息内容标题(Velocity)")
    private String subject;

    @ApiModelProperty(value = "消息内容模板(Velocity)")
    private String content;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "删除标记")
    private Integer deleteFlag;

    /**
     * 未删除 & 启用 ====> 状态可用
     */
    public boolean available() {
        return ObjectUtil.isNotNull(deleteFlag) && deleteFlag.compareTo(0) == 0
                && ObjectUtil.isNotNull(status) && status.compareTo(1) == 0;
    }
}
