/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.data.etl.transform.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import com.elitesland.cbpl.data.etl.transform.spi.ToolContextSpi;
import com.elitesland.cbpl.data.etl.util.BeanFormat;
import com.elitesland.cbpl.data.etl.util.DateFormat;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import com.lzhpo.tracer.util.TracerUtils;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformUtil {
    private static final Logger logger = LoggerFactory.getLogger(TransformUtil.class);
    private static VelocityEngine velocityEngine;

    private static VelocityEngine getInstance() {
        if (velocityEngine == null) {
            velocityEngine = new VelocityEngine();
            velocityEngine.init();
        }
        return velocityEngine;
    }

    public static String parse(VelocityContext context, String logTag, String inString) {
        context.put("traceId", (Object)TracerUtils.getTraceId());
        context.put("date", (Object)new DateFormat());
        context.put("bean", (Object)new BeanFormat());
        if (SpringUtils.isPresent(ToolContextSpi.class)) {
            ToolContextSpi toolContext = (ToolContextSpi)SpringUtils.getBean(ToolContextSpi.class);
            toolContext.register(context);
        }
        StringWriter out = new StringWriter();
        boolean result = TransformUtil.getInstance().evaluate((Context)context, (Writer)out, logTag, inString);
        if (!result) {
            logger.error("[PHOENIX][ETL] transform error: {}, {}, {}", new Object[]{logTag, inString, context});
            throw PhoenixException.unchecked((String)"transform error.");
        }
        String outString = out.toString();
        LogUtil.info((String)logTag, (String)"[PHOENIX][ETL] \u8f6c\u6362\u540e\u62a5\u6587: ", (Object)outString);
        return outString;
    }

    public static String parseToJsonStr(VelocityContext context, String logTag, String inString) {
        return JSONUtil.toJsonPrettyStr((Object)TransformUtil.parse(context, logTag, inString));
    }

    public static String parse(Object data, String inString) {
        return TransformUtil.parseToDefault(data, inString, "");
    }

    public static String parseOrThrow(Object data, String inString) {
        Assert.notNull((Object)data, (String)"[PHOENIX][ETL] \u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)inString, (String)"[PHOENIX][ETL] \u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        VelocityContext context = new VelocityContext();
        context.put("ctx", data);
        return TransformUtil.parse(context, "", inString);
    }

    public static String parseToDefault(Object data, String inString, String defaultValue) {
        try {
            return TransformUtil.parseOrThrow(data, inString);
        }
        catch (IllegalArgumentException e) {
            logger.error("[PHOENIX][ETL] transform IllegalArgument: {}, {}", (Object)inString, data);
        }
        catch (Exception e) {
            logger.error("[PHOENIX][ETL] transform error: {}, {}", new Object[]{inString, data, e});
        }
        return defaultValue;
    }
}

