package com.elitesland.cbpl.infinity.client.account.interceptor;

import cn.hutool.core.util.CharsetUtil;
//import com.elitesland.cbpl.cloudt.tenant.TenantUtil;
import com.elitesland.cbpl.infinity.client.util.InfinitySession;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import com.elitesland.cbpl.infinity.web.common.constant.InfinityStatus;
import com.elitesland.cbpl.infinity.web.common.vo.InfinityResult;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.protocol.HTTP;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

import static com.elitesland.cbpl.infinity.client.router.util.InfinityUtil.checkSignature;
import static org.springframework.http.MediaType.APPLICATION_JSON_VALUE;

/**
 * @author eric.hao
 * @since 2023/05/30
 */
@Slf4j
@Data
@NoArgsConstructor
public class AuthInterceptor implements HandlerInterceptor {

    private List<InfinityAccountRespVO> accounts;

    public AuthInterceptor(List<InfinityAccountRespVO> accounts) {
        this.accounts = accounts;
    }

    @Override
    public boolean preHandle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler) throws IOException {
        response.addHeader(HTTP.CONTENT_TYPE, APPLICATION_JSON_VALUE);
        response.setCharacterEncoding(CharsetUtil.UTF_8);
        try {
            // get header token
            final String requestMethod = request.getMethod();
            final String token = request.getHeader("Authorization");
            log.info("[PHOENIX-INFINITY] checkApiToken: check token,request method={}, header token={}", requestMethod, token);
            // token
            if (StringUtils.isBlank(token)) {
                var result = InfinityResult.fail(InfinityStatus.UNAUTHORIZED, "非法请求参数，认证失败");
                response.getWriter().write(BeanUtils.toJsonStr(result));
                log.error("[PHOENIX-INFINITY] 请求参数非法，请核实!");
                return false;
            }
            Optional<InfinityAccountRespVO> matchAccount = accounts.stream()
                    .filter(account -> checkSignature(token, account.getUsername(), account.getPassword())).findFirst();
            if (matchAccount.isEmpty()) {
                var result = InfinityResult.fail(InfinityStatus.NOT_AUTHORITATIVE, "用户名密码，认证失败");
                response.getWriter().write(BeanUtils.toJsonStr(result));
                log.error("[PHOENIX-INFINITY] checkApiToken: authorization invalid, head Authorization={}", token);
                return false;
            }
            // 设置当前Infinity账户
            InfinitySession.setCurrentAccount(matchAccount.get());
            // 设置当前租户
            // TenantUtil.setCurrentTenant(matchAccount.get().getBelongTenant());
            return true;
        } catch (Exception e) {
            var result = InfinityResult.fail(InfinityStatus.INTERNAL_ERROR, "认证异常，请联系管理员");
            response.getWriter().write(BeanUtils.toJsonStr(result));
            log.error("[PHOENIX-INFINITY] checkApiToken: catch e.", e);
            return false;
        } finally {
        }
    }

    @Override
    public void postHandle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler, ModelAndView modelAndView) {
        // TenantUtil.resetCurrentTenant();
        InfinitySession.clearCurrentAccount();
    }

    @Override
    public void afterCompletion(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler, Exception e) {
    }
}
